% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_quantize_per_tensor}
\alias{torch_quantize_per_tensor}
\title{Quantize_per_tensor}
\usage{
torch_quantize_per_tensor(self, scale, zero_point, dtype)
}
\arguments{
\item{self}{(Tensor) float tensor to quantize}

\item{scale}{(float) scale to apply in quantization formula}

\item{zero_point}{(int) offset in integer value that maps to float zero}

\item{dtype}{(\code{torch.dtype}) the desired data type of returned tensor.        Has to be one of the quantized dtypes: \code{torch_quint8}, \code{torch.qint8}, \code{torch.qint32}}
}
\description{
Quantize_per_tensor
}
\section{quantize_per_tensor(input, scale, zero_point, dtype) -> Tensor }{


Converts a float tensor to quantized tensor with given scale and zero point.
}

\examples{
if (torch_is_installed()) {
torch_quantize_per_tensor(torch_tensor(c(-1.0, 0.0, 1.0, 2.0)), 0.1, 10, torch_quint8())
torch_quantize_per_tensor(torch_tensor(c(-1.0, 0.0, 1.0, 2.0)), 0.1, 10, torch_quint8())$int_repr()
}
}
