% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_gelu}
\alias{nn_gelu}
\title{GELU module}
\usage{
nn_gelu()
}
\description{
Applies the Gaussian Error Linear Units function:
\deqn{\mbox{GELU}(x) = x * \Phi(x)}
}
\details{
where \eqn{\Phi(x)} is the Cumulative Distribution Function for Gaussian Distribution.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_gelu()
input <- torch_randn(2)
output <- m(input)
}
}
