% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_allclose}
\alias{torch_allclose}
\title{Allclose}
\usage{
torch_allclose(self, other, rtol = 1e-05, atol = 1e-08, equal_nan = FALSE)
}
\arguments{
\item{self}{(Tensor) first tensor to compare}

\item{other}{(Tensor) second tensor to compare}

\item{rtol}{(float, optional) relative tolerance. Default: 1e-05}

\item{atol}{(float, optional) absolute tolerance. Default: 1e-08}

\item{equal_nan}{(bool, optional) if \code{TRUE}, then two \code{NaN} s will be compared as equal. Default: \code{FALSE}}
}
\description{
Allclose
}
\section{allclose(input, other, rtol=1e-05, atol=1e-08, equal_nan=False) -> bool }{


This function checks if all \code{input} and \code{other} satisfy the condition:

\deqn{
    \vert \mbox{input} - \mbox{other} \vert \leq \mbox{atol} + \mbox{rtol} \times \vert \mbox{other} \vert
}
elementwise, for all elements of \code{input} and \code{other}. The behaviour of this function is analogous to
\verb{numpy.allclose <https://docs.scipy.org/doc/numpy/reference/generated/numpy.allclose.html>}_
}

\examples{
if (torch_is_installed()) {

torch_allclose(torch_tensor(c(10000., 1e-07)), torch_tensor(c(10000.1, 1e-08)))
torch_allclose(torch_tensor(c(10000., 1e-08)), torch_tensor(c(10000.1, 1e-09)))
torch_allclose(torch_tensor(c(1.0, NaN)), torch_tensor(c(1.0, NaN)))
torch_allclose(torch_tensor(c(1.0, NaN)), torch_tensor(c(1.0, NaN)), equal_nan=TRUE)
}
}
