% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_polar}
\alias{torch_polar}
\title{Polar}
\usage{
torch_polar(abs, angle)
}
\arguments{
\item{abs}{(Tensor) The absolute value the complex tensor. Must be float or
double.}

\item{angle}{(Tensor) The angle of the complex tensor. Must be same dtype as
\code{abs}.}
}
\description{
Polar
}
\section{polar(abs, angle, *, out=None) -> Tensor }{


Constructs a complex tensor whose elements are Cartesian coordinates
corresponding to the polar coordinates with absolute value \code{abs} and angle
\code{angle}.

\deqn{
    \mbox{out} = \mbox{abs} \cdot \cos(\mbox{angle}) + \mbox{abs} \cdot \sin(\mbox{angle}) \cdot j
}
}

\examples{
if (torch_is_installed()) {

abs <- torch_tensor(c(1, 2), dtype=torch_float64())
angle <- torch_tensor(c(pi / 2, 5 * pi / 4), dtype=torch_float64())
z <- torch_polar(abs, angle)
z
}
}
