% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_index_select}
\alias{torch_index_select}
\title{Index_select}
\usage{
torch_index_select(self, dim, index)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension in which we index}

\item{index}{(LongTensor) the 1-D tensor containing the indices to index}
}
\description{
Index_select
}
\note{
The returned tensor does \strong{not} use the same storage as the original
tensor.  If \code{out} has a different shape than expected, we
silently change it to the correct shape, reallocating the underlying
storage if necessary.
}
\section{index_select(input, dim, index, out=NULL) -> Tensor }{


Returns a new tensor which indexes the \code{input} tensor along dimension
\code{dim} using the entries in \code{index} which is a \code{LongTensor}.

The returned tensor has the same number of dimensions as the original tensor
(\code{input}).  The \code{dim}\ th dimension has the same size as the length
of \code{index}; other dimensions have the same size as in the original tensor.
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(3, 4))
x
indices = torch_tensor(c(1, 3), dtype = torch_int64())
torch_index_select(x, 1, indices)
torch_index_select(x, 2, indices)
}
}
