% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-rnn.R
\name{nn_lstm}
\alias{nn_lstm}
\title{Applies a multi-layer long short-term memory (LSTM) RNN to an input
sequence.}
\usage{
nn_lstm(
  input_size,
  hidden_size,
  num_layers = 1,
  bias = TRUE,
  batch_first = FALSE,
  dropout = 0,
  bidirectional = FALSE,
  ...
)
}
\arguments{
\item{input_size}{The number of expected features in the input \code{x}}

\item{hidden_size}{The number of features in the hidden state \code{h}}

\item{num_layers}{Number of recurrent layers. E.g., setting \code{num_layers=2}
would mean stacking two LSTMs together to form a \verb{stacked LSTM},
with the second LSTM taking in outputs of the first LSTM and
computing the final results. Default: 1}

\item{bias}{If \code{FALSE}, then the layer does not use bias weights \code{b_ih} and \code{b_hh}.
Default: \code{TRUE}}

\item{batch_first}{If \code{TRUE}, then the input and output tensors are provided
as (batch, seq, feature). Default: \code{FALSE}}

\item{dropout}{If non-zero, introduces a \code{Dropout} layer on the outputs of each
LSTM layer except the last layer, with dropout probability equal to
\code{dropout}. Default: 0}

\item{bidirectional}{If \code{TRUE}, becomes a bidirectional LSTM. Default: \code{FALSE}}

\item{...}{currently unused.}
}
\description{
For each element in the input sequence, each layer computes the following
function:
}
\details{
\deqn{
\begin{array}{ll} \\
i_t = \sigma(W_{ii} x_t + b_{ii} + W_{hi} h_{(t-1)} + b_{hi}) \\
f_t = \sigma(W_{if} x_t + b_{if} + W_{hf} h_{(t-1)} + b_{hf}) \\
g_t = \tanh(W_{ig} x_t + b_{ig} + W_{hg} h_{(t-1)} + b_{hg}) \\
o_t = \sigma(W_{io} x_t + b_{io} + W_{ho} h_{(t-1)} + b_{ho}) \\
c_t = f_t c_{(t-1)} + i_t g_t \\
h_t = o_t \tanh(c_t) \\
\end{array}
}

where \eqn{h_t} is the hidden state at time \code{t}, \eqn{c_t} is the cell
state at time \code{t}, \eqn{x_t} is the input at time \code{t}, \eqn{h_{(t-1)}}
is the hidden state of the previous layer at time \code{t-1} or the initial hidden
state at time \code{0}, and \eqn{i_t}, \eqn{f_t}, \eqn{g_t},
\eqn{o_t} are the input, forget, cell, and output gates, respectively.
\eqn{\sigma} is the sigmoid function.
}
\note{
All the weights and biases are initialized from \eqn{\mathcal{U}(-\sqrt{k}, \sqrt{k})}
where \eqn{k = \frac{1}{\mbox{hidden\_size}}}
}
\section{Inputs}{


Inputs: input, (h_0, c_0)
\itemize{
\item \strong{input} of shape \verb{(seq_len, batch, input_size)}: tensor containing the features
of the input sequence.
The input can also be a packed variable length sequence.
See \code{\link[=nn_utils_rnn_pack_padded_sequence]{nn_utils_rnn_pack_padded_sequence()}} or
\code{\link[=nn_utils_rnn_pack_sequence]{nn_utils_rnn_pack_sequence()}} for details.
\item \strong{h_0} of shape \verb{(num_layers * num_directions, batch, hidden_size)}: tensor
containing the initial hidden state for each element in the batch.
\item \strong{c_0} of shape \verb{(num_layers * num_directions, batch, hidden_size)}: tensor
containing the initial cell state for each element in the batch.
}

If \verb{(h_0, c_0)} is not provided, both \strong{h_0} and \strong{c_0} default to zero.
}

\section{Outputs}{


Outputs: output, (h_n, c_n)
\itemize{
\item \strong{output} of shape \verb{(seq_len, batch, num_directions * hidden_size)}: tensor
containing the output features \code{(h_t)} from the last layer of the LSTM,
for each t. If a \code{torch_nn.utils.rnn.PackedSequence} has been
given as the input, the output will also be a packed sequence.
For the unpacked case, the directions can be separated
using \code{output$view(c(seq_len, batch, num_directions, hidden_size))},
with forward and backward being direction \code{0} and \code{1} respectively.
Similarly, the directions can be separated in the packed case.
\item \strong{h_n} of shape \verb{(num_layers * num_directions, batch, hidden_size)}: tensor
containing the hidden state for \code{t = seq_len}.
Like \emph{output}, the layers can be separated using
\code{h_n$view(c(num_layers, num_directions, batch, hidden_size))} and similarly for \emph{c_n}.
\item \strong{c_n} (num_layers * num_directions, batch, hidden_size): tensor
containing the cell state for \code{t = seq_len}
}
}

\section{Attributes}{

\itemize{
\item \code{weight_ih_l[k]} : the learnable input-hidden weights of the \eqn{\mbox{k}^{th}} layer
\code{(W_ii|W_if|W_ig|W_io)}, of shape \verb{(4*hidden_size x input_size)}
\item \code{weight_hh_l[k]} : the learnable hidden-hidden weights of the \eqn{\mbox{k}^{th}} layer
\code{(W_hi|W_hf|W_hg|W_ho)}, of shape \verb{(4*hidden_size x hidden_size)}
\item \code{bias_ih_l[k]} : the learnable input-hidden bias of the \eqn{\mbox{k}^{th}} layer
\code{(b_ii|b_if|b_ig|b_io)}, of shape \code{(4*hidden_size)}
\item \code{bias_hh_l[k]} : the learnable hidden-hidden bias of the \eqn{\mbox{k}^{th}} layer
\code{(b_hi|b_hf|b_hg|b_ho)}, of shape \code{(4*hidden_size)}
}
}

\examples{
if (torch_is_installed()) {
rnn <- nn_lstm(10, 20, 2)
input <- torch_randn(5, 3, 10)
h0 <- torch_randn(2, 3, 20)
c0 <- torch_randn(2, 3, 20)
output <- rnn(input, list(h0, c0))

}
}
