% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_relu}
\alias{nn_relu}
\title{ReLU module}
\usage{
nn_relu(inplace = FALSE)
}
\arguments{
\item{inplace}{can optionally do the operation in-place. Default: \code{FALSE}}
}
\description{
Applies the rectified linear unit function element-wise
\deqn{\mbox{ReLU}(x) = (x)^+ = \max(0, x)}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_relu()
input <- torch_randn(2)
m(input)

}
}
