% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_sum}
\alias{torch_sum}
\title{Sum}
\usage{
torch_sum(self, dim, keepdim = FALSE, dtype = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int or tuple of ints) the dimension or dimensions to reduce.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        If specified, the input tensor is casted to \code{dtype} before the operation        is performed. This is useful for preventing data type overflows. Default: NULL.}
}
\description{
Sum
}
\section{sum(input, dtype=NULL) -> Tensor }{


Returns the sum of all elements in the \code{input} tensor.
}

\section{sum(input, dim, keepdim=False, dtype=NULL) -> Tensor }{


Returns the sum of each row of the \code{input} tensor in the given
dimension \code{dim}. If \code{dim} is a list of dimensions,
reduce over all of them.

If \code{keepdim} is \code{TRUE}, the output tensor is of the same size
as \code{input} except in the dimension(s) \code{dim} where it is of size 1.
Otherwise, \code{dim} is squeezed (see \code{\link{torch_squeeze}}), resulting in the
output tensor having 1 (or \code{len(dim)}) fewer dimension(s).
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(1, 3))
a
torch_sum(a)


a <- torch_randn(c(4, 4))
a
torch_sum(a, 1)
b <- torch_arange(1, 4 * 5 * 6)$view(c(4, 5, 6))
torch_sum(b, list(2, 1))
}
}
