% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_torch_function.R
\name{call_torch_function}
\alias{call_torch_function}
\title{Call a (Potentially Unexported) Torch Function}
\usage{
call_torch_function(name, ..., quiet = FALSE)
}
\arguments{
\item{name}{Name of the function to call as a string. Should start with "torch_"}

\item{...}{A list of arguments to pass to the function. Argument splicing with
\verb{!!!} is supported.}

\item{quiet}{If TRUE, suppress warnings with valuable information about the dangers of
this function.}
}
\value{
The return value from calling the function \code{name} with arguments \code{...}
}
\description{
This function allows calling a function prefixed with \code{torch_}, including unexported
functions which could have potentially valuable uses but which do not yet have
a user-friendly R wrapper function. Therefore, this function should be used with
extreme caution. Make sure you understand what the function expects as input. It
may be helpful to read the \code{torch} source code for help with this, as well as
the documentation for the corresponding function in the Pytorch C++ API. Generally
for development and advanced use only.
}
\examples{
if (torch_is_installed()) {
## many unexported functions do 'backward' calculations (e.g. derivatives)
## These could be used as a part of custom autograd functions for example.
x <- torch_randn(10, requires_grad = TRUE)
y <- torch_tanh(x)
## calculate backwards gradient using standard torch method
y$backward(torch_ones_like(x))
x$grad
## we can get the same result by calling the unexported `torch_tanh_backward()`
## function. The first argument is 1 to setup the Jacobian-vector product.
## see https://pytorch.org/blog/overview-of-pytorch-autograd-engine/ for details.
call_torch_function("torch_tanh_backward", 1, y)
all.equal(call_torch_function("torch_tanh_backward", 1, y, quiet = TRUE), x$grad)
}
}
