% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-pooling.R
\name{nnf_fractional_max_pool3d}
\alias{nnf_fractional_max_pool3d}
\title{Fractional_max_pool3d}
\usage{
nnf_fractional_max_pool3d(
  input,
  kernel_size,
  output_size = NULL,
  output_ratio = NULL,
  return_indices = FALSE,
  random_samples = NULL
)
}
\arguments{
\item{input}{the input tensor}

\item{kernel_size}{the size of the window to take a max over. Can be a single number \eqn{k}
(for a square kernel of \eqn{k * k * k}) or a tuple \verb{(kT, kH, kW)}}

\item{output_size}{the target output size of the form \eqn{oT * oH * oW}.
Can be a tuple \verb{(oT, oH, oW)} or a single number \eqn{oH} for a cubic output
\eqn{oH * oH * oH}}

\item{output_ratio}{If one wants to have an output size as a ratio of the
input size, this option can be given. This has to be a number or tuple in the
range (0, 1)}

\item{return_indices}{if \code{True}, will return the indices along with the outputs.}

\item{random_samples}{undocumented argument.}
}
\description{
Applies 3D fractional max pooling over an input signal composed of several input planes.
}
\details{
Fractional MaxPooling is described in detail in the paper \verb{Fractional MaxPooling}_ by Ben Graham

The max-pooling operation is applied in \eqn{kT * kH * kW} regions by a stochastic
step size determined by the target output size.
The number of output features is equal to the number of input planes.
}
