% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tranforms.R
\name{transform_sliding_window_cmn}
\alias{transform_sliding_window_cmn}
\title{sliding-window Cepstral Mean Normalization}
\usage{
transform_sliding_window_cmn(
  cmn_window = 600,
  min_cmn_window = 100,
  center = FALSE,
  norm_vars = FALSE
)
}
\arguments{
\item{cmn_window}{(int, optional): Window in frames for running average CMN computation (int, default = 600)}

\item{min_cmn_window}{(int, optional):  Minimum CMN window used at start of decoding (adds latency only at start).
Only applicable if center == \code{FALSE}, ignored if center==\code{TRUE}  (int, default = 100)}

\item{center}{(bool, optional): If \code{TRUE}, use a window centered on the current frame
(to the extent possible, modulo end effects). If \code{FALSE}, window is to the left. (bool, default = \code{FALSE})}

\item{norm_vars}{(bool, optional): If \code{TRUE}, normalize variance to one. (bool, default = \code{FALSE})}
}
\value{
Tensor: Tensor of audio of dimension (..., time).
}
\description{
Apply sliding-window cepstral mean  (and optionally variance) normalization per utterance.
}
\details{
forward param:
waveform  (Tensor): Tensor of audio of dimension (..., time).
}
