% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_band_biquad}
\alias{functional_band_biquad}
\title{Two-pole Band Filter (functional)}
\usage{
functional_band_biquad(
  waveform,
  sample_rate,
  central_freq,
  Q = 0.707,
  noise = FALSE
)
}
\arguments{
\item{waveform}{(Tensor): audio waveform of dimension of \verb{(..., time)}}

\item{sample_rate}{(int): sampling rate of the waveform, e.g. 44100 (Hz)}

\item{central_freq}{(float): central frequency (in Hz)}

\item{Q}{(float, optional): https://en.wikipedia.org/wiki/Q_factor (Default: \code{0.707}).}

\item{noise}{(bool, optional) : If \code{TRUE}, uses the alternate mode for un-pitched audio
(e.g. percussion). If \code{FALSE}, uses mode oriented to pitched audio, i.e. voice, singing,
or instrumental music  (Default: \code{FALSE}).}
}
\value{
\code{tensor}: Waveform of dimension of \verb{(..., time)}
}
\description{
Design two-pole band filter.  Similar to SoX implementation.
}
\references{
\itemize{
\item \url{https://sox.sourceforge.net/sox.html}
\item \url{https://webaudio.github.io/Audio-EQ-Cookbook/audio-eq-cookbook.html}
}
}
