% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yogi.R
\name{optim_yogi}
\alias{optim_yogi}
\title{Yogi optimizer}
\usage{
optim_yogi(
  params,
  lr = 0.01,
  betas = c(0.9, 0.999),
  eps = 0.001,
  initial_accumulator = 1e-06,
  weight_decay = 0
)
}
\arguments{
\item{params}{List of parameters to optimize.}

\item{lr}{Learning rate (default: 1e-3)}

\item{betas}{Coefficients computing running averages of gradient
and its square (default: (0.9, 0.999))}

\item{eps}{Term added to the denominator to improve numerical
stability (default: 1e-8)}

\item{initial_accumulator}{Initial values for first and
second moments.}

\item{weight_decay}{Weight decay (L2 penalty) (default: 0)}
}
\value{
A torch optimizer object implementing the \code{step} method.
}
\description{
R implementation of the Yogi optimizer proposed
by Zaheer et al.(2019). We used the implementation available at
https://github.com/jettify/pytorch-optimizer/blob/master/torch_optimizer/yogi.py.
Thanks to Nikolay Novik for providing the pytorch code.

The original implementation is licensed using the Apache-2.0 software license.
This implementation is also licensed using Apache-2.0 license.

From the abstract by the paper by Zaheer et al.(2019):
Adaptive gradient methods that rely on scaling gradients
down by the square root of exponential moving averages
of past squared gradients, such RMSProp, Adam, Adadelta have
found wide application in optimizing the nonconvex problems
that arise in deep learning. However, it has been recently
demonstrated that such methods can fail to converge even
in simple convex optimization settings.
Yogi is a new adaptive optimization algorithm,
which controls the increase in effective learning rate,
leading to even better performance with similar theoretical
guarantees on convergence. Extensive experiments show that
Yogi with very little hyperparameter tuning outperforms
methods such as Adam in several challenging machine learning tasks.
}
\examples{
if (torch::torch_is_installed()) {
# function to demonstrate optimization
beale <- function(x, y) {
    log((1.5 - x + x * y)^2 + (2.25 - x - x * y^2)^2 + (2.625 - x + x * y^3)^2)
 }
# define optimizer
optim <- torchopt::optim_yogi
# define hyperparams
opt_hparams <- list(lr = 0.01)

# starting point
x0 <- 3
y0 <- 3
# create tensor
x <- torch::torch_tensor(x0, requires_grad = TRUE)
y <- torch::torch_tensor(y0, requires_grad = TRUE)
# instantiate optimizer
optim <- do.call(optim, c(list(params = list(x, y)), opt_hparams))
# run optimizer
steps <- 400
x_steps <- numeric(steps)
y_steps <- numeric(steps)
for (i in seq_len(steps)) {
    x_steps[i] <- as.numeric(x)
    y_steps[i] <- as.numeric(y)
    optim$zero_grad()
    z <- beale(x, y)
    z$backward()
    optim$step()
}
print(paste0("starting value = ", beale(x0, y0)))
print(paste0("final value = ", beale(x_steps[steps], y_steps[steps])))
}
}
\references{
Manzil Zaheer, Sashank Reddi, Devendra Sachan, Satyen Kale, Sanjiv Kumar,
"Adaptive Methods for Nonconvex Optimization",
Advances in Neural Information Processing Systems 31 (NeurIPS 2018).
https://papers.nips.cc/paper/8186-adaptive-methods-for-nonconvex-optimization
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Souza, \email{lipecaso@gmail.com}

Alber Sanchez, \email{alber.ipia@inpe.br}
}
