% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{ops_deform_conv2d}
\alias{ops_deform_conv2d}
\title{Performs Deformable Convolution v2,}
\usage{
ops_deform_conv2d(
  input,
  offset,
  weight,
  bias = NULL,
  stride = c(1, 1),
  padding = c(0, 0),
  dilation = c(1, 1),
  mask = NULL
)
}
\arguments{
\item{input}{(\code{Tensor[batch_size, in_channels, in_height, in_width]}): input tensor}

\item{offset}{(\code{Tensor[batch_size, 2 * offset_groups * kernel_height * kernel_width, out_height, out_width]}):
offsets to be applied for each position in the convolution kernel.}

\item{weight}{(\verb{Tensor[out_channels, in_channels // groups, kernel_height, kernel_width]}): convolution weights,
split into groups of size (in_channels // groups)}

\item{bias}{(\code{Tensor[out_channels]}): optional bias of shape (out_channels,). Default: \code{NULL}}

\item{stride}{(int or \code{Tuple[int, int]}): distance between convolution centers. Default: 1}

\item{padding}{(int or \code{Tuple[int, int]}): height/width of padding of zeroes around
each image. Default: 0}

\item{dilation}{(int or \code{Tuple[int, int]}): the spacing between kernel elements. Default: 1}

\item{mask}{(\code{Tensor[batch_size, offset_groups * kernel_height * kernel_width, out_height, out_width]}):
masks to be applied for each position in the convolution kernel. Default: \code{NULL}}
}
\value{
\code{Tensor[batch_sz, out_channels, out_h, out_w]}: result of convolution
}
\description{
Ddescribed in \href{https://arxiv.org/abs/1811.11168}{Deformable ConvNets v2: More Deformable, Better Results}
if \code{mask} is not \code{NULL} and performs Deformable Convolution, described in
\href{https://arxiv.org/abs/1703.06211}{Deformable Convolutional Networks}
if \code{mask} is \code{NULL}.
}
\examples{
if (torchvisionlib_is_installed()) {
  library(torch)
  input <- torch_rand(4, 3, 10, 10)
  kh <- kw <- 3
  weight <- torch_rand(5, 3, kh, kw)
  # offset and mask should have the same spatial size as the output
  # of the convolution. In this case, for an input of 10, stride of 1
  # and kernel size of 3, without padding, the output size is 8
  offset <- torch_rand(4, 2 * kh * kw, 8, 8)
  mask <- torch_rand(4, kh * kw, 8, 8)
  out <- ops_deform_conv2d(input, offset, weight, mask = mask)
  print(out$shape)
}
}
