% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterID.R
\name{filterID}
\alias{filterID}
\alias{filterID.default}
\alias{filterID.textmeta}
\title{Subcorpus With ID Filter}
\usage{
filterID(...)

\method{filterID}{default}(text, id, ...)

\method{filterID}{textmeta}(object, id, filtermeta = TRUE, ...)
}
\arguments{
\item{...}{Not used.}

\item{text}{Not necassary if \code{object} is specified, else should be
\code{object$text}: list of article texts}

\item{id}{Character: IDs the corpus should be filtered to.}

\item{object}{A \code{\link{textmeta}} object}

\item{filtermeta}{Logical: Should the meta component be filtered, too?}
}
\value{
\code{\link{textmeta}} object if \code{object} is specified,
else only the filtered \code{text}. If a \code{\link{textmeta}} object is
returned its meta data are filtered to those texts which appear in the corpus
by default (\code{filtermeta}).
}
\description{
Generates a subcorpus by restricting it to specific ids.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

meta <- data.frame(id = c("C", "B"), date = NA, title = c("Fisher", "Fish"),
stringsAsFactors = FALSE)
tm <- textmeta(text = texts, meta = meta)

filterID(texts, c("A", "B"))
filterID(texts, "C")
filterID(tm, "C")
filterID(tm, "B")
filterID(tm, c("B", "A"), FALSE)
}
