% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topTexts.R
\name{topTexts}
\alias{topTexts}
\title{Get The IDs Of The Most Representive Texts}
\usage{
topTexts(
  ldaresult,
  ldaID,
  limit = 20L,
  rel = TRUE,
  select = 1:nrow(ldaresult$document_sums),
  tnames,
  minlength = 30L
)
}
\arguments{
\item{ldaresult}{LDA result}

\item{ldaID}{Vector of text IDs}

\item{limit}{Integer: Number of text IDs per topic.}

\item{rel}{Logical: Should be the relative frequency be used?}

\item{select}{Which topics should be returned?}

\item{tnames}{Names of the selected topics}

\item{minlength}{Minimal total number of words a text must have to be
included}
}
\value{
Matrix of text IDs.
}
\description{
The function extracts the text IDs belonging to the texts with the highest relative or
absolute number of words per topic.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

corpus <- cleanTexts(corpus)
wordlist <- makeWordlist(corpus$text)
ldaPrep <- LDAprep(text=corpus$text, vocab=wordlist$words)

\donttest{LDA <- LDAgen(documents=ldaPrep, K = 3L, vocab=wordlist$words, num.words=3)}
\donttest{topTexts(ldaresult=LDA, ldaID=c("A","B","C"), limit = 1L, minlength=2)}
}
\keyword{manip}
