% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.R
\name{get_formals}
\alias{get_formals}
\title{Get formals of a Function}
\usage{
get_formals(uri, content, func)
}
\arguments{
\item{uri}{Path to R file.}

\item{content}{R code as string.}

\item{func}{Function name. If a function is defined multiple times inside the
provided file, only the last occurence will be considered.}
}
\value{
A named character vector as returned by \code{\link[=formals]{formals()}}.
}
\description{
Returns the arguments of a function from a valid R file.
}
\examples{
uri <- system.file("testfiles/funcs.R", package = "toscutil")
content <- readLines(uri)
func <- "f2"
get_formals(uri, content, func)
}
\keyword{func}
