% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{is.none}
\alias{is.none}
\title{Truth checking as in Python}
\usage{
is.none(x)
}
\arguments{
\item{x}{object to test}
}
\value{
\code{TRUE} if \code{x} is \code{FALSE}, 0, \code{NULL}, \code{NA}, an empty list or an empty
string. Else \code{FALSE.}
}
\description{
Returns \code{TRUE} if \code{x} is either \code{FALSE}, \code{0}, \code{NULL}, \code{NA}and
empty lists or an empty string. Inspired by python's
\href{https://docs.python.org/3/library/functions.html#bool}{bool}.
}
\examples{
is.none(FALSE) # TRUE
is.none(0) # TRUE
is.none(1) # FALSE
is.none(NA) # TRUE
is.none(list()) # TRUE
is.none("") # TRUE
is.none(character()) # TRUE
is.none(numeric()) # TRUE
is.none(logical()) # TRUE
}
\keyword{check}
