% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_decennial.R
\name{read_decennial}
\alias{read_decennial}
\title{Read decennial census data}
\usage{
read_decennial(year, states, table_contents = NULL, areas = NULL,
  geo_headers = NULL, summary_level = NULL, geo_comp = "total",
  show_progress = TRUE)
}
\arguments{
\item{year}{year of the decennial census}

\item{states}{vector of state abbreviations, for example "IN" or c("MA", "RI").}

\item{table_contents}{selected references of contents in census tables. Users
can choose a name for each reference, such as in
c("abc = PCT012F139", "fff = P0030008", "rural_p = P0020005").
Try to make names meaningful. To find the references of table contents
of interest, search with function \code{\link{search_tablecontents}}.}

\item{areas}{For metro area, in the format like "New York metro".
For county, city, or town, must use the exact name as those in
\code{\link{dict_fips}} in the format like "kent county, RI",
"Boston city, MA", and "Lincoln town, RI". And special examples like
"Salt Lake City city, UT" must keep the "city" after "City".}

\item{geo_headers}{vector of references of selected geographci headers to be
included in the return. Search with \code{\link{search_geoheaders}}}

\item{summary_level}{select which summary level to keep, default to keep all. It takes strings
including "state", "county", "county subdivision", "place", "tract", "block group",
and "block" for the most common levels. It also take code for level. Search all codes with
\code{\link{search_summarylevels}}.}

\item{geo_comp}{select which geographic component to keep, "*" to keep every geo-component,
"total" for "00", "urban" for "01", "urbanized area" for "04",
"urban cluster" for "28", "rural" for "43". For all other geographic component,
 use code,
which can be found with \code{\link{search_geocomponents}}. Availability
of geocomponent depends on summary level. State level contains all
geographic component. County subdivision and higher level have "00",
"01", and "43". Census tract and lower level have only "00".}

\item{show_progress}{show progress of file reading if TRUE. Turn off if FALSE, which
is useful in RMarkdown output.}
}
\value{
A data.table whose columns include the selected geoheaders and
table contents plus SUMLEV, GEOCOMP, and state.
}
\description{
This function retrieves data from summary file 1 (with urban/rural update)
of decennial censuses. In addition to selected geographic headers and table contents,
it also returns total population and coordinates of selected geographic
areas, as well as summary levels and geographic components.
}
\examples{
\dontrun{
# read one table and one area from one state
aaa = read_decennial(
    year = 2010,
    states = "UT",
    table_contents = c("urban = P0020002", "rural = P0020005"),
    geo_headers = "CBSA",
    summary_level = "tract"
)


# read multiple table contents and areas from multiple states
bbb = read_decennial(
    year = 2010,
    states = c("UT", "RI"),
    table_contents = c("urban = P0020002", "rural = P0020005"),
    areas = c(
        "place = ut62360",
        "Providence city, RI",
        "cousub = ri41500",
        "cbsa = 39300"
    ),
    summary_level = "block"
)


# read table contents of all county subdivisions in Providence metro
library(data.table)
library(magrittr)
ccc <- read_decennial(
    year = 2010,
    states = "US",
    table_contents = c("urban = P0020002", "rural = P0020005"),
    geo_headers = c("NAME", "CBSA"),
    summary_level = "county subdivision",
    geo_comp = "*"
) \%>\%
    .[CBSA == "39300"]
}

}
