% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display-depth.r
\name{display_depth}
\alias{display_depth}
\alias{animate_depth}
\title{Display 3d projection with depth cues}
\usage{
display_depth(center = TRUE, half_range = NULL, ...)

animate_depth(data, tour_path = grand_tour(3), ...)
}
\arguments{
\item{center}{should projected data be centered to have mean zero (default:
TRUE). This pins the centre of the data to the same place, and makes it
easier to focus on the shape.}

\item{half_range}{half range to use when calculating limits of projected.
If not set, defaults to maximum distance from origin to each row of data.}

\item{...}{other arguments passed on to \code{\link{animate}}}

\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator, defaults to 2d grand tour}
}
\description{
Suggestion to use gray background and colour saturation (instead of
gray shading) by Graham Wills.
}
\examples{
animate_depth(flea[, 1:6])
}
\seealso{
\code{\link{animate}} for options that apply to all animations
}
\keyword{hplot}
