% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.r
\name{render}
\alias{render}
\title{Render frames of animation to disk}
\usage{
render(
  data,
  tour_path,
  display,
  dev,
  ...,
  apf = 1/10,
  frames = 50,
  rescale = TRUE,
  sphere = FALSE,
  start = NULL
)
}
\arguments{
\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator}

\item{display}{the method used to render the projected data,
e.g. \code{\link{display_xy}}, \code{\link{display_pcp}}}

\item{dev}{name of output device to use (e.g. \code{\link{png}},
\code{\link{pdf}})}

\item{...}{other options passed to output device}

\item{apf}{angle (in radians) per frame}

\item{frames}{number of frames in output}

\item{rescale}{if true, rescale all variables to range [0,1]}

\item{sphere}{if true, sphere all variables}

\item{start}{starting projection.  If \code{NULL}, uses path default.}
}
\description{
Render frames of animation to disk
}
\examples{
\donttest{
tmp_path <- tempdir()
render(flea[, 1:6], grand_tour(), display_xy(), "pdf",
  frames = 3,
  file.path(tmp_path, "test.pdf")
)
render(flea[, 1:6], grand_tour(), display_xy(), "png",
  frames = 3,
  file.path(tmp_path, "test-\%03d.png")
)
}
}
\keyword{hplot}
