% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxbootmc.R
\name{toxbootmc}
\alias{toxbootmc}
\title{Filter and multicore wrapper for \code{\link{toxboot}}}
\usage{
toxbootmc(dat, m4ids = NULL, filter = TRUE, boot_method = "smooth",
  cores = 1L, destination = "memory", ...)
}
\arguments{
\item{dat}{data.table returned from \code{\link{toxbootQueryToxCast}}}

\item{m4ids}{list of m4ids to perform bootstrap calculation. By default
NULL, which will run on all m4ids in the in dat.}

\item{filter}{logical, default TRUE. If TRUE dat will be filtered to remove
m4ids that are already in the mongoDB. Ignored if \code{destination} is not
"mongo".}

\item{boot_method}{parameter passed to \code{\link{toxboot}}. Used also if
\code{filter} is TRUE.}

\item{cores}{integer length 1, number of cores to supply as mc.cores to
\code{\link{mclapply}}. By default set to 1L which will work on all systems
including Windows. Increase to the number of cores on your system (see
\code{\link{detectCores}}) to perform calculations in parallel.}

\item{destination}{string length 1, options are "mongo", "mysql", "file", "memory"}

\item{...}{parameters passed to \code{\link{toxboot}}}
}
\value{
dat, a data.table corresponding to the level 3 data for the aeids
  with columns added for \code{m4id} and \code{bmad}.
}
\description{
\code{toxbootmc} calculates bootstrapped curves for multiple m4ids using
mclapply to perform the calculation on many cores.
}
\details{
The function \code{\link{toxboot}} takes performs bootstrap analysis
  on a single m4id included in the data.table supplied. This function acts as
  a wrapping and cleaning function around \code{\link{toxboot}} to both
  simplify setup with common defaults and to provide multicore support
  through the use of \code{\link{mclapply}}.
}
