% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyFunctions.R
\name{createImageSeq}
\alias{createImageSeq}
\title{Create image sequence}
\usage{
createImageSeq(moviepath, imagepath, x = 1915, y = 1080, fps = 15,
  nsec = 2, ext = "MTS", path = getwd())
}
\arguments{
\item{moviepath}{Path to directory containing the video files.}

\item{imagepath}{Path to location of directory in which image sequences should
be saved.}

\item{x}{Number of pixels in horizontal direction; default is 1915 (HD).}

\item{y}{Number of pixels in vertical direction; default is 1080 (HD).}

\item{fps}{Frames per second, default is 15.}

\item{nsec}{Duration of movie that is exported, default is 2 seconds.
When movie length is greater than \code{nsec}, the \code{nsec} seconds 
in the exact middle of the movie are exported.}

\item{ext}{The extension of the video. Default is \code{'MTS'}. All
formats supported by "avconv" are accepted.}

\item{path}{Path to location where temporary python file will be saved. Default 
is working directory.}
}
\description{
\code{createImageSeq} creates an image sequences (.png) using
 video files as input. All movies within a directory will  
be converted into an image sequence.
For each movie, a new directory is created containing the recorded date and 
name of the movie.
}
\author{
Marjolein Bruijning, Caspar A. Hallmann & Marco D. Visser
}
