% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyFunctions.R
\name{loadImages}
\alias{loadImages}
\title{Load .png images}
\usage{
loadImages(dirPictures, filenames = NULL, nImages = 1:30, xranges = NULL,
  yranges = NULL)
}
\arguments{
\item{dirPictures}{The path of the folder where the images can be found.}

\item{filenames}{Default is \code{NULL}, or all files. If all files should 
NOT be loaded, here specify which files to use, as a character string.}

\item{nImages}{Numeric vector specifying which images in the directory 
should be loaded; default is \code{1:30}.}

\item{xranges}{By default the full image is loaded; specify to subset the number of columns.}

\item{yranges}{By default the full image is loaded; specify to subset the number of rows.}
}
\value{
Array of class 'TrDm' and 'colorimages' containing all loaded images.
}
\description{
\code{loadImages} loads png images as three dimensional arrays.
The objects created through the function can be used for image analysis.
}
\examples{
\dontrun{
images <- loadImages(direcPictures='~/images1/',
                     nImages=1:30,yranges=1:1080,xranges=1:1915)
plot(images)
images
}
}
\author{
Marjolein Bruijning, Caspar A. Hallmann & Marco D. Visser
}
