% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultsFunctions.R
\name{runBatch}
\alias{runBatch}
\title{Batch analysis}
\usage{
runBatch(path, settings = NULL, dirnames = NULL, nImages = 1:30,
  pixelRange = NULL, threshold = -0.1, qthreshold = NULL,
  select = "dark", nn = NULL, incThres = NULL, plotOutput = FALSE,
  plotType = "trajectories", L = 20, R = 2, weight = c(1, 1, 1),
  autoThres = FALSE, perFrame = FALSE, methodBg = "mean", frames = NULL,
  saveAll = FALSE)
}
\arguments{
\item{path}{A character vector of path name that contains all directories with
image sequences.}

\item{settings}{Object of class 'tracked' containing all optimized settings
in attributes,
as obtained from \code{\link{trackParticles}}.
Alternatively, settings can be specified using arguments described below.}

\item{dirnames}{If not all image sequences should be
analyzed, specificy which files to use as a character string.}

\item{nImages}{See \code{\link{loadImages}}}

\item{pixelRange}{See \code{\link{identifyParticles}}}

\item{threshold}{See \code{\link{identifyParticles}}}

\item{qthreshold}{See \code{\link{identifyParticles}}}

\item{select}{See \code{\link{identifyParticles}}}

\item{nn}{Name of artifical neural net if apply it to images. Default
is \code{NULL}, resulting in no neural net being applied.}

\item{incThres}{Minimum number of frames that a particle must be
present. By default, automated estimate is used.}

\item{plotOutput}{Default is \code{FALSE}. Set \code{TRUE} to plot results.}

\item{plotType}{Default is 'trajectories'. Other options are 'sizes' and 'animation'.}

\item{L}{See \code{\link{trackParticles}}}

\item{R}{See \code{\link{trackParticles}}}

\item{weight}{See \code{\link{trackParticles}}}

\item{autoThres}{See \code{\link{identifyParticles}}}

\item{perFrame}{See \code{\link{identifyParticles}}}

\item{methodBg}{See \code{\link{createBackground}}}

\item{frames}{See \code{\link{identifyParticles}}}

\item{saveAll}{Logical. Set \code{TRUE} to save for each image sequence the full object obtained from
\code{\link{loadImages}}. Default is FALSE.}
}
\value{
Dataframe with estimated population size for each image sequence.
}
\description{
\code{runBatch} analyzes all image sequences in a specified
directory. Use this function when settings have been optimized 
previously on a single or selection of movies/image sequences.
}
\examples{
\dontrun{
results <- runBatch(path='images',
                    nImages=1:30,threshold=0.2,select='both',
                    pixelRange=c(1,100),L=50,R=3,
                    incThres=1,plotOutput=TRUE,plotType='trajectories',
                    weight=c(1,0,1))
results
}
}
\seealso{
\code{\link{loadImages}}, \code{\link{createBackground}},
\code{\link{subtractBackground}}, \code{\link{identifyParticles}},
\code{\link{trackParticles}}.
}
\author{
Marjolein Bruijning, Caspar A. Hallmann & Marco D. Visser
}
