% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.qda}
\alias{train.qda}
\title{train.qda}
\usage{
train.qda(formula, data, ..., subset, na.action)
}
\arguments{
\item{formula}{A formula of the form groups ~ x1 + x2 + ... That is, the response is the grouping factor and the right hand side specifies the (non-factor) discriminators.}

\item{data}{An optional data frame, list or environment from which variables specified in formula are preferentially to be taken.}

\item{...}{Arguments passed to or from other methods.}

\item{subset}{An index vector specifying the cases to be used in the training sample. (NOTE: If given, this argument must be named.)}

\item{na.action}{Function to specify the action to be taken if NAs are found. The default action is for the procedure to fail.
An alternative is na.omit, which leads to rejection of cases with missing values on any required variable.
(NOTE: If given, this argument must be named.)}
}
\value{
A object qda.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[MASS]{qda}}.
}
\note{
The parameter information was taken from the original function \code{\link[MASS]{qda}}.
}
\examples{

len <- nrow(iris)
sampl <- sample(x = 1:len,size = len*0.20,replace = FALSE)
ttesting <- iris[sampl,]
ttraining <- iris[-sampl,]
model.qda <- train.qda(Species~.,ttraining)
model.qda
prediction <- predict(model.qda, ttesting)
prediction

}
\seealso{
The internal function is from package \code{\link[MASS]{qda}}.
}
