% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize_traits}
\alias{standardize_traits}
\alias{standardise_traits}
\alias{standardize.traits}
\title{Standardize trait names and harmonize measured values and reported facts}
\usage{
standardize_traits(x, thesaurus = attributes(x)$thesaurus,
  rename = NULL, categories = c("No", "Yes"), output = "logical",
  ...)
}
\arguments{
\item{x}{a traitdata object (as returned by \code{as.traitdata()}) or a data table
containing at least the column `scientificName.}

\item{thesaurus}{an object of class 'thesaurus' (as returned by
\code{as.thesaurus()}).}

\item{rename}{a named vector to map user-provided names to thesaurus object
names (see Details).}

\item{categories}{target categories for binary/logical traits harmonization.}

\item{output}{behaviour of \code{fixlogical()}. see \code{\link[=fixlogical]{fixlogical()}}.}

\item{...}{parameters to be ignored, forwarded from wrapper function \code{standardize()}.}
}
\description{
Adds columns to a traitdata table with standardized trait names
and relates them to globally unique identifiers via URIs. Optionally
converts units of values and renames factor levels into accepted terms.
}
\details{
The function matches the trait names provided in 'traitName' to the
traits provided in the thesaurus (in field 'trait'). Matching must be exact
(case sensitive). Fuzzy matching may be provided in a later version of the
package.

The function parameter 'rename' should be provided to map trait names where
user-provided names and thesaurus names are different. In this case, rename
should be a named vector with the target names used in the thesaurus as
names, and the original names as provided in 'traitName' as value. E.g.
\code{rename = c()}
}
\examples{


pulldata("carabids")

dataset1 <- as.traitdata(carabids, 
  taxa = "name_correct", 
  traits = c("body_length", "antenna_length", "metafemur_length"),
  units = "mm",
  keep = c(datasetID = "source_measurement", measurementRemark = "note"), 
  metadata = list(
    bibliographicCitation = attributes(carabids)$citeAs,
    author = "Fons van der Plas", 
    license = "http://creativecommons.org/publicdomain/zero/1.0/"
    )
)

traitlist <- as.thesaurus(
body_length = as.trait("body_length", expectedUnit = "mm", valueType = "numeric",
   identifier = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Body_length"), 
antenna_length = as.trait("antenna_length", expectedUnit = "mm", valueType = "numeric",
   identifier = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Antenna_length"),
metafemur_length = as.trait("metafemur_length", expectedUnit = "mm", valueType = "numeric",
   identifier = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Femur_length")
)

dataset1Std <- standardize_traits(dataset1, thesaurus = traitlist)



## Example: matching of original names to thesaurus

pulldata("heteroptera_raw")

dataset2 <- as.traitdata(heteroptera_raw, 
  taxa = "SpeciesID", 
  traits = c("Body_length", "Antenna_Seg1", "Antenna_Seg2",
    "Antenna_Seg3", "Antenna_Seg4", "Antenna_Seg5", "Hind.Femur_length"),
  units = "mm", 
  keep = c(sex = "Sex", references = "Source", lifestage = "Wing_development"),
  metadata = list(
    bibliographicCitation = attributes(heteroptera_raw)$citeAs, 
    license = "http://creativecommons.org/publicdomain/zero/1.0/"
    )
)


traits2 <- as.thesaurus(
    Body_length = as.trait("Body_length",
            expectedUnit = "mm", valueType = "numeric",
            traitDescription = "From the tip of the head to the end of the abdomen"),
    Antenna_Seg1 = as.trait("Antenna_Seg1",
            expectedUnit = "mm", valueType = "numeric",
            traitDescription = "Length of first antenna segment",
            broaderTerm = "http://ecologicaltraitdata.github.io/TraitDataList/Antenna_length"),
    Antenna_Seg2 = as.trait("Antenna_Seg2",
            expectedUnit = "mm", valueType = "numeric",
            traitDescription = "Length of second antenna segment",
            broaderTerm = "http://ecologicaltraitdata.github.io/TraitDataList/Antenna_length"),
    Antenna_Seg3 = as.trait("Antenna_Seg3",
            expectedUnit = "mm", valueType = "numeric",
            traitDescription = "Length of third antenna segment",
            broaderTerm = "http://ecologicaltraitdata.github.io/TraitDataList/Antenna_length"),
    Antenna_Seg4 = as.trait("Antenna_Seg4",
            expectedUnit = "mm", valueType = "numeric",
            traitDescription = "Length of fourth antenna segment",
            broaderTerm = "http://ecologicaltraitdata.github.io/TraitDataList/Antenna_length"),
    Antenna_Seg5 = as.trait("Antenna_Seg5",
            expectedUnit = "mm", valueType = "numeric",
            traitDescription = "Length of fifth antenna segment (only Pentatomoidea)",
            broaderTerm = "http://ecologicaltraitdata.github.io/TraitDataList/Antenna_length"),
    Hind.Femur_length = as.trait("Hind.Femur_length",
            expectedUnit = "mm", valueType = "numeric",
            traitDescription = "Length of the femur of the hind leg",
            broaderTerm = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Femur_length")
    )

dataset2Std <- standardize_traits(dataset2, 
    thesaurus = traits2
    )

}
\seealso{
Other standardize: \code{\link{standardize_taxa}},
  \code{\link{standardize}}

Other standardize: \code{\link{standardize_taxa}},
  \code{\link{standardize}}
}
\concept{standardize}
