% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_data.R
\name{split_data}
\alias{split_data}
\title{Split observed data into multiple subsets}
\usage{
split_data(
  obsdata,
  total_followup,
  ntimes_interval,
  time,
  time_values,
  identifier
)
}
\arguments{
\item{obsdata}{Observed data in wide format.}

\item{total_followup}{Total length of follow-up.}

\item{ntimes_interval}{Number of measuring times per interval.}

\item{time}{Name of the time variable.}

\item{time_values}{Measuring times.}

\item{identifier}{Identifier of individuals.}
}
\value{
\item{all_df}{ All subsets, list of time intervals.}
}
\description{
Function to split the data into multiple subsets of size s each
one subset corresponding to one time-interval.
}
\examples{
obsdata = gendata(n = 1000, format = "long", total_followup = 8, seed = 945)
years <- 2011:2018
res = split_data(obsdata = obsdata, total_followup = 8,
ntimes_interval = 6,time = "time", time_values = years,identifier = "id")
}
\author{
Awa Diop Denis Talbot
}
