% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{varcov.tramME}
\alias{varcov.tramME}
\title{Extract the variance-covariance matrix of the random effects}
\usage{
\method{varcov}{tramME}(object, ...)
}
\arguments{
\item{object}{A tramME object (fitted or unfitted).}

\item{...}{Optional arguments (unused)}
}
\value{
A list of the covariance matrices.
}
\description{
Returns the covariance matrix of the random effects as saved in the tramME object.
The returned values correspond to the transformation model parametrization.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
varcov(fit)
}
