% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.tramME}
\alias{vcov.tramME}
\title{Calculate the variance-covariance matrix of the parameters}
\usage{
\method{vcov}{tramME}(
  object,
  parm = NULL,
  pargroup = c("all", "fixef", "shift", "baseline", "ranef"),
  pmatch = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted tramME object.}

\item{parm}{The indeces or names of the parameters of interest. See in details.}

\item{pargroup}{fixef: fixed-effects, shift: shift parameters, all: fixed
effects and variance component parameters, baseline: parameters of the
baseline transformation function, ranef: variance components parameters.}

\item{pmatch}{Logical. If \code{TRUE}, partial name matching is allowed.}

\item{...}{Optional arguments}
}
\value{
A numeric covariance matrix.
}
\description{
Extracts the covariance matrix of the selected parameters. The returned values
are on the same scale as the estimated parameter values, i.e. the standard
deviations of the random effect terms are on log scale.
}
\details{
The argument \code{parm} defines the indices or the names of the parameters
of interest within the selected \code{pargroup}. When \code{pmatch = TRUE},
partial matching of parameter names is allowed.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy, order = 10)
vcov(fit)
vcov(fit, pargroup = "ranef")
vcov(fit, pargroup = "baseline")
vcov(fit, parm = "Reaction") ## same as previous
}
