% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pvalues}
\alias{pvalues}
\title{Extract set and predictor p-values from tramicp outputs}
\usage{
pvalues(object, which = c("predictor", "set", "all"))
}
\arguments{
\item{object}{Object of class \code{'dicp'}}

\item{which}{Which p-values to return, \code{"predictor"} returns p-values
for individual predictors, \code{"set"} for each subset of the predictors,
\code{"all"} returns a list of both}
}
\value{
Numeric vector (or list in case \code{which = "all"}) of p-values
}
\description{
Extract set and predictor p-values from tramicp outputs
}
\details{
Predictor p-values are computed from the set p-values as follows:
    For each predictor j as the largest p-value of all sets not containing j.
}
\examples{
set.seed(123)
d <- dgp_dicp(n = 1e3, mod = "polr")
res <- polrICP(Y ~ X1 + X2 + X3, data = d, env = ~ E, type = "wald")
pvalues(res, which = "predictor")
pvalues(res, which = "set")
pvalues(res, which = "all")

}
