% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramvs.R
\name{abess_tram}
\alias{abess_tram}
\title{Optimal subset selection for transformation models}
\usage{
abess_tram(
  formula,
  data,
  modFUN,
  supp,
  mandatory = NULL,
  k_max = supp,
  thresh = NULL,
  init = TRUE,
  m_max = 10,
  m0 = NULL,
  ...
)
}
\arguments{
\item{formula}{object of class \code{"formula"}.}

\item{data}{data frame containing the variables in the model.}

\item{modFUN}{function for fitting a transformation model, e.g., \code{BoxCox()}.}

\item{supp}{support size of the coefficient vector}

\item{mandatory}{formula of mandatory covariates, which will always be included
and estimated in the model. Note that this also changes the intialization
of the active set. The active set is then computed with regards to the
model residuals of \code{modFUN(mandatory, ...)} instead of the unconditional
model.}

\item{k_max}{maximum support size to consider during the splicing algorithm.
Defaults to \code{supp}.}

\item{thresh}{threshold when to stop splicing. Defaults to
0.01 * \code{supp} * p * log(log(n)) / n$, where p denotes the number of predictors
and n the sample size.}

\item{init}{initialize active set. Defaults to \code{TRUE} and initializes the
active set with those covariates that are most correlated with score residuals
of an unconditional \code{modFUN(update(formula, . ~ 1))}.}

\item{m_max}{maximum number of iterating the splicing algorithm.}

\item{m0}{Transformation model for initialization}

\item{...}{additional arguments supplied to \code{modFUN}.}
}
\value{
List containing the fitted model via \code{modFUN}, active set
    \code{A} and inactive set \code{I}.
}
\description{
Optimal subset selection for transformation models
}
\examples{
set.seed(24101968)
library(tramvs)

N <- 1e2
P <- 5
nz <- 3
beta <- rep(c(1, 0), c(nz, P - nz))
X <- matrix(rnorm(N * P), nrow = N, ncol = P)
Y <- 1 + X \%*\% beta + rnorm(N)

dat <- data.frame(y = Y, x = X)

abess_tram(y ~ ., dat, modFUN = Lm, supp = 3)

}
