% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssFrequencies.R
\name{xpssFrequencies}
\alias{xpssFrequencies}
\title{Simple descriptive statistics}
\usage{
xpssFrequencies(x, variables, missing = NULL, barchart = list(plot = FALSE,
  min = NULL, max = NULL, freq = NULL, percent = NULL), piechart = list(plot =
  FALSE, min = NULL, max = NULL, freq = NULL, percent = NULL, missing = FALSE),
  histogram = list(plot = FALSE, min = NULL, max = NULL, freq = NULL, percent
  = NULL, normal = FALSE), ntiles = NULL, percentiles = NULL,
  statistics = c("mean", "stddev", "minimum", "maximum"))
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{variables}{atomic character or character vector with the name of the variables.}

\item{missing}{atomic character which specifiy the missing method. The method indicates what should happen when the data contains NAs. Default is \code{"NULL"}. Optionally it is possible to include user-defined missing values with \code{"include"}.}

\item{barchart}{plot a barchart. Default for \code{plot} is \code{NULL}. If \code{plot} is \code{TRUE} an default barchart will be plotted. Optional for customized barchart a list with the following arguments has to be assigned \code{minimum(n)}, \code{maximum(n)} to bound lower and upper values which are not plotted. See notes for more.}

\item{piechart}{plot a piechart. Default for \code{plot} is \code{NULL}. If \code{plot} is \code{TRUE} an default an default piechart will be plotted. Optional for customized piechart a list with the following arguments has to be assigned \code{minimum(n)}, \code{maximum(n)} to bound lower and upper values which are not plotted. See notes for more.}

\item{histogram}{plot a histogram.  Default for \code{plot} is \code{NULL}. If \code{plot} is \code{TRUE} an default histogram will be plotted. Optional for customized histogram a list with the following arguments has to be assigned \code{minimum(n)}, \code{maximum(n)} to bound lower and upper values which are not plotted. With \code{normal} a overlapping normal distrubtion line will drawn. Default is \code{FALSE}.  See notes for more.}

\item{ntiles}{divides the distribution in a specific percentage amount of categories. multiple dividing in distributions is allowed. Default is \code{NULL}.}

\item{percentiles}{displays the value between customized percentiles. Default is \code{NULL}.}

\item{statistics}{Method which enumerate the descriptive statistics. Default is \code{mean}, \code{stddev}, \code{minimum}, \code{maximum}. Optional arguments are \code{all},\code{kurtosis}, \code{median}, \code{mode}, \code{none}, \code{range}, \code{sekurt}, \code{semean}, \code{seskew}, \code{skewness}, \code{sum}, \code{variance}.}
}
\description{
R Implementation of the SPSS Function \code{FREQUENCIES}.
}
\details{
The xpssFrenquencies function provides a set of descriptive statistic tools. The function delivers frequency tables containing value labels, values, frequencies, percentages of the selected variables in the dataset. Furthermore, xpssFrequency supplies three types of visualization of categorical or continous numerical:
\enumerate{
\item barchart
\item histogram
\item piechart
}

It is possible to customize the graphics by indiviual parameters. If TRUE is set, the default graphic will be plotted.

\strong{\code{individual graphic parameter (for all charts):}}

\tabular{rll}{
\tab \code{max=n} \tab Cut the amount of maximum till n elements.
\cr \tab \code{min=n} \tab Cut the amount of n till minimum elements.
\cr \tab \code{freq=n} \tab Displays the distrubtion in absolute values on the basis of a user-defined maxima, the maxima has to be higher then the maxima of the distribtion, freq=max(n) is the default. (except piechart).
\cr \tab \code{percent=n} \tab Displays the distrubtion in relative values on the basis of a user-defined maxima, the maxima has to be higher then the maxima of the distribtion, percent=max(n) is the default. (except piechart).
}
\strong{\code{individual graphic parameter (for histogram):}}
\tabular{rll}{
\tab \code{normal=T} \tab Draws a overlapping normal curve.
}
\strong{\code{individual graphic parameter (for piechart):}}
\tabular{rll}{
\tab \code{missing=T} \tab Displays or excludes Missing Values.
}

\strong{\code{statistics:}}
\tabular{rll}{

\tab \code{kurtosis} \tab calculates the bulge of the variable.
\cr \tab \code{maxixmum} \tab displays the maximum of the variable.
\cr \tab \code{mean} \tab calculates the arithmetic mean.
\cr \tab \code{median} \tab calculates the median.
\cr \tab \code{minimum} \tab displays the minimum of the variable.
\cr \tab \code{mode} \tab displays the modal value of the variable.
\cr \tab \code{none} \tab displays no statistics.
\cr \tab \code{range} \tab displays the span between the minimum and the maximum value.
\cr \tab \code{sekurtosis} \tab calculates the standrard error of the bulge of the variable.
\cr \tab \code{semean} \tab displays the standard error of the arithmetic mean.
\cr \tab \code{seskewness} \tab calculates the standrard error of the inclination of the variable.
\cr \tab \code{skewness} \tab calculates the inclination of the variable.
\cr \tab \code{stddev} \tab  displays the standard deviation of the variable.
\cr \tab \code{sum} \tab calculates the sum of each observation within the variable.
\cr \tab \code{variance} \tab displays the variance.}
}
\examples{
data(fromXPSS)
xpssFrequencies(x=fromXPSS,
 variables=c("V5"))

xpssFrequencies(x=fromXPSS,
 variables=c("V3","V7_2"),
 ntiles=c(0.25,0.3),
 percentiles=c(0.23,0.46,0.88))

xpssFrequencies(x=fromXPSS,
 variables=c("V3","V7_2"),
 histogram=list(plot=TRUE))

 xpssFrequencies(x=fromXPSS,
 variables=c("V3"),
 piechart=list(plot=TRUE,min=0,max=2))

 xpssFrequencies(x=fromXPSS,
 variables=c("V3"),
 barchart=list(plot=TRUE,precent=50))
}
\author{
Bastian Wiessner
}

