#' transmem: Treatment of membrane-transport data.
#'
#' Treatment and visualization of membrane (selective) transport
#' data. Transport profiles involving up to three species are produced as
#' publication-ready plots and several membrane performance parameters
#' (e.g. separation factors as defined in Koros et al. (1996)
#' <doi:10.1351/pac199668071479> and non-linear regression parameters
#' for the equations described in Rodriguez de San Miguel et al. (2014)
#' <doi:10.1016/j.jhazmat.2014.03.052>) can be obtained. Many widely used
#' experimental setups (e.g. membrane physical aging) can be easily studied
#' through the package's graphical representations.
#'
#' @author Cristhian Paredes, \email{craparedesca@@unal.edu.co}
#' @author Eduardo Rodriguez de San Miguel, \email{erdsmg@@unam.mx}
#' @references
#'   C. Paredes, E. Rodriguez de San Miguel, Polymer inclusion membrane for
#'   the recovery and concentration of lithium from seawater. Master thesis,
#'   Universidad Nacional Autónoma de México, México City, México, 2020.
#'
#' @docType package
#' @name transmem-package
NULL
