% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbalanced.R
\name{plot.ut_pgrid}
\alias{plot.ut_pgrid}
\title{Plot Unbalanced Transport Information}
\usage{
\method{plot}{ut_pgrid}(x, what = c("plan", "extra", "trans", "inplace"), axes = FALSE, ...)
}
\arguments{
\item{x}{the list returned by \code{\link{unbalanced}} with option \code{output="all"}.}

\item{what}{character. The aspect of the unbalanced transport information to display.}

\item{axes}{logical. Whether to plot axes (ignored for \code{what="plan"}).}

\item{...}{further graphics parameters passed to \code{\link{plot.pgrid}} for 
\code{what="plan"} and passed to \code{\link{matimage}} in all other cases.}
}
\value{
Nothing. Used for the side effect.
}
\description{
Graphic representation of components of the list returned by \code{\link{unbalanced}}.
}
\examples{
\dontrun{
res <- unbalanced( random32a, random32b, p=1, C=0.2, output="all" )
plot( res, what="plan", lwd=1.5, angle=20 )
plot( res, what="trans" )
plot( res, what="extra" )
plot( res, what="inplace" )}
}
