% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{extract}
\alias{extract}
\alias{.predict.sta}
\alias{.predict.sim}
\alias{.coef.sta}
\alias{.coef.sim}
\alias{.weights.sta}
\alias{.weights.sim}
\alias{.which.stack}
\title{Internal functions}
\usage{
.predict.sta(object, newx, ...)

.predict.sim(object, newx, ...)

.coef.sta(object, ...)

.coef.sim(object, ...)

.weights.sta(object, ...)

.weights.sim(object, ...)

.which.stack(object, stack)
}
\arguments{
\item{object}{object of class \code{transreg}}

\item{newx}{features:
matrix with \eqn{n} rows (samples) and \eqn{p} columns (variables)}

\item{...}{(not applicable)}

\item{stack}{character "sta" (standard stacking) or "sim" (simultaneous stacking)}
}
\description{
Internal functions called by
\code{\link[=coef.transreg]{coef.transreg()}}, \code{\link[=predict.transreg]{predict.transreg()}} and \code{\link[=weights.transreg]{weights.transreg()}},
depending on choice between
standard stacking
and simultaneous stacking.
}
\section{Functions}{
\itemize{
\item \code{.predict.sta()}: called by \code{predict.transreg} if \code{stack="sta"}

\item \code{.predict.sim()}: called by \code{predict.transreg} if \code{stack="sim"}

\item \code{.coef.sta()}: called by \code{coef.transreg} if \code{stack="sta"}

\item \code{.coef.sim()}: called by \code{coef.transreg} if \code{stack="sim"}

\item \code{.weights.sta()}: called by \code{weights.transreg} if \code{stack="sta"}

\item \code{.weights.sim()}: called by \code{weights.transreg} if \code{stack="sim"}

\item \code{.which.stack()}: called by \code{coef.transreg}, \code{predict.transreg} and \code{weights.transreg}

}}
\seealso{
Use \code{\link[=coef.transreg]{coef}},
\code{\link[=predict.transreg]{predict}}
and \code{\link[=weights.transreg]{weights}}.
}
