% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateDiscreteDistributions.R
\name{ModLSD_Var}
\alias{ModLSD_Var}
\title{Computes the variance of the modified logarithmic series distribution}
\usage{
ModLSD_Var(delta, p)
}
\arguments{
\item{delta}{parameter \eqn{\delta} of the modified logarithmic series
distribution}

\item{p}{parameter of the modified logarithmic series distribution}
}
\value{
Mean of the modified logarithmic series distribution
}
\description{
Computes the variance of the modified logarithmic series distribution
}
\details{
A random variable \eqn{X} has modified logarithmic series
 distribution with parameters \eqn{0\le \delta <1} and \eqn{0<p<1}  if
 \eqn{P(X=0)=(1-\delta)} and \deqn{P(X=x)=(1-\delta)(-1)/(\log(1-p))p^x/x,
 \mbox{ for }  x=1,2,\dots.}
}
\examples{
ModLSD_Var(0.2,0.5)
}
