% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.treats.R
\name{make.treats}
\alias{make.treats}
\title{Make a treats object}
\usage{
make.treats(tree, data)
}
\arguments{
\item{tree}{a phylogenetic tree.}

\item{data}{a dataset of traits, either a \code{matrix} with column names or a named \code{vector}.}
}
\value{
This function outputs a \code{treats} object that is a list of at least two elements: \code{$tree}, a \code{"phylo"} object and \code{$data}, a \code{"matrix"} of the trait values.
}
\description{
Combines a tree and some associated data into a treats object (e.g. for plotting)
}
\examples{
## Creating a random tree
my_tree <- rtree(5)
## Adding node labels
my_tree$node.label <- letters[1:4]
## Creating a random dataset
my_data <- matrix(rnorm(9),
    dimnames = list(c(my_tree$tip.label, my_tree$node.label)))
## Creating the treats object
my_treats <- make.treats(tree = my_tree, data = my_data)
plot(my_treats)

}
\seealso{
\code{\link{treats}} \code{\link{plot.treats}}
}
\author{
Thomas Guillerme
}
