% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initHMM.R
\name{initHMM}
\alias{initHMM}
\title{Initializing treeHMM with given parameters}
\usage{
initHMM(States, Symbols, treemat, startProbs = NULL, transProbs = NULL,
  emissionProbs = NULL)
}
\arguments{
\item{States}{A (2 * 1) vector with first element being discrete state value for the cases(or positive) and second element being discrete state value for the controls(or negative) for given treeHMM}

\item{Symbols}{List containing (M * 1) vectors for discrete values of emissions(where "M" is the possible number of emissions) for each feature variable}

\item{treemat}{Adjacent Symmetry Matrix that describes the topology of the tree}

\item{startProbs}{(N * 1) vector containing starting probabilities for the states, where "N" is the possible number of states(Optional). Default is equally probable states}

\item{transProbs}{(N * N) matrix containing transition probabilities for the states, where "N" is the possible number of states(Optional)}

\item{emissionProbs}{List of (N * M) matrices containing emission probabilities for the states, for each feature variable(optional). Default is equally probable emissions}
}
\value{
List describing the parameters of treeHMM(pi, alpha, beta)
}
\description{
Initializing treeHMM with given parameters
}
\examples{
tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped tree
states = c("P","N") #"P" represent cases(or positive) and "N" represent controls(or negative)
hmmA = initHMM(states,list(c("L","R")), tmat) #one feature with two discrete levels "L" and "R"
hmmB = initHMM(states, list(c("X","Y")),tmat, c(0.5,0.5), matrix(c(0.7,0.3,0.3,0.7),2,2))
}
