% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cherryI.R
\name{cherryI}
\alias{cherryI}
\title{Calculation of the cherry index for rooted trees}
\usage{
cherryI(tree)
}
\arguments{
\item{tree}{A rooted tree in phylo format.}
}
\value{
\code{cherryI} returns the cherry index of the given tree.
}
\description{
This function calculates the cherry index \eqn{ChI(T)} for a
given rooted tree \eqn{T}. The tree must not necessarily be binary.
\eqn{ChI(T)} is defined as the number of cherries in the tree. A cherry
is a pair of leaves that have the same direct ancestor. Note, if a vertex \eqn{u}
has \eqn{x} leaves as direct descendants, the number of cherries induced by \eqn{u} is
\eqn{binom(x,2)}{binom(x,2)}. \cr\cr
The cherry index does not fulfill the definition
of an (im)balance index given in "Tree balance indices: a comprehensive survey"
(Fischer et al., 2021).
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
cherryI(tree)
tree <- ape::read.tree(text="((,),((((,),),),(,)));")
cherryI(tree)
tree <- ape::read.tree(text="((,,,),(,,));")
cherryI(tree)

}
\references{
A. McKenzie and M. Steel. Distributions of cherries for two models of trees. Mathematical Biosciences, 164(1):81-92, 2000. doi: 10.1016/s0025-5564(99)00060-7.
}
\author{
Sophie Kersting
}
