% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treediff.R
\name{treediff}
\alias{treediff}
\alias{summary.treeTest}
\alias{print.treeTest}
\title{Treediff}
\usage{
treediff(trees1, trees2, replicates, scale = FALSE, order_labels = FALSE)

\method{print}{treeTest}(x, ...)

\method{summary}{treeTest}(object, ...)
}
\arguments{
\item{trees1}{A list of trees corresponding to the first condition (set).
Trees are structured into groups (or clusters) with the same number of
replicates in each group. Trees are ordered by groups and then by replicates:
\{group1+rep1, group1+rep2, ...\}. One test is performed for each group.}

\item{trees2}{A list of trees corresponding to the second condition. Trees
are also structured in groups (or clusters) that are exactly the same than
for the first condition. The number of replicates in each group can be
different from that of \code{trees1}.}

\item{replicates}{A numeric vector of length 2 with the number of replicates
for each condition.}

\item{scale}{Logical. If \code{TRUE}, the trees are all rescaled to have a
minimum height equal to 0 and a maximum height equal to 1. Default to
\code{FALSE}.}

\item{order_labels}{Logical. If \code{TRUE}, align leaves ordering in all
trees (required if your trees don't have their leaves ordered identically).
Default to \code{FALSE}.}

\item{x}{a \code{treeTest} object to print}

\item{...}{not used}

\item{object}{a \code{treeTest} object to print}
}
\value{
An object of class \code{treeTest} with the following entries:
\itemize{
  \item{p.value}{ the p-value for the treediff test.}
  \item{statistic}{ the value of the Student's statistic of each leaf pair of
  the tree test.}
  \item{p.value.indiv}{ the p-value of the Student's test for each leaf pair
  of the tree test.}
  \item{method}{ a character string indicating what type of test was
  performed.}
  \item{data.name}{ a character string giving the names of the tree
  conditions.}
}
}
\description{
Perform the treediff test to compare two sets of trees.
}
\details{
This function compares two sets of trees using a p-value aggregation
method. The p-values are obtained by the treediff method, as described in
(Neuvial \emph{et al.}, 2023).
}
\examples{
leaves <- c(100, 120, 50, 80)

trees <- sapply(leaves, FUN = function(leaf) {
  base_data <- matrix(rnorm(2000), nrow = leaf, ncol = 200)

## generates two sets of trees with 4 clusters with 100, 120, 50 and 80
## leaves respectively
## 4 replicates in the first condition and 6 in the second condition

  set1 <- replicate(4, sample(1:100, 50, replace = FALSE))
  set2 <- replicate(6, sample(101:200, 50, replace = FALSE))

  trees1 <- apply(set1, 2, function(asample) {
    samples <- base_data[, asample]
    out <- hclust(dist(samples), method = "ward.D2")
    return(out)
  })

  trees2 <- apply(set2, 2, function(asample) {
    samples <- base_data[, asample]
    out <- hclust(dist(samples), method = "ward.D2")
    return(out)
  })
  return(list("trees1" = trees1, "trees2" = trees2))
})

trees1 <- unlist(trees[1, ], recursive = FALSE)
trees2 <- unlist(trees[2, ], recursive = FALSE)
replicates <- c(4, 6)

tree_pvals <- treediff(trees1, trees2, replicates)
## 4 p-values, one for each cluster
tree_pvals$p.value
}
\references{
Neuvial Pierre, Randriamihamison Nathanaël, Chavent Marie,
Foissac Sylvain and Vialaneix Nathalie (2023) Testing differences in
structure between families of trees. \emph{Preprint submitted for
publication}.
}
\author{
Gwendaëlle Cardenas\cr
Marie Chavent \email{marie.chavent@u-bordeaux.fr}\cr
Sylvain Foissac \email{sylvain.foissac@inrae.fr}\cr
Pierre Neuvial \email{pierre.neuvial@math.univ-toulouse.fr}\cr
Nathanaël Randriamihamison\cr
Nathalie Vialaneix \email{nathalie.vialaneix@inrae.fr}
}
