% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{drop_extinct}
\alias{drop_extinct}
\title{Drops extinct tips from tree}
\usage{
drop_extinct(phy, tol = NULL)
}
\arguments{
\item{phy}{a 'phylo' class object}

\item{tol}{tolerance in decimal values for branch lengths}
}
\value{
A 'phylo' class object with extinct tips removed
}
\description{
Drops extinct tips from tree
}
\examples{
mu <- 0.5 # death rate
lambda <- 2.0 # birth rate
numb_replicates <- 10
numb_extant_tips <- 4
# simulate trees under the GSA so first simulates a tree with
# numb_extant_tips * 100 tips counting each time we have a tree with 10 tips
# then randomly picks one of those trees

tree_list <- sim_sptree_bdp(sbr = lambda,
                sdr = mu,
                numbsim = numb_replicates,
                n_tips = numb_extant_tips)
pruned <- drop_extinct(tree_list[[1]])

}
\references{
Pennell M, Eastman J, Slater G, Brown J, Uyeda J, Fitzjohn R, Alfaro M, Harmon L (2014). “geiger v2.0: an expanded suite of methods for fitting macroevolutionary models to phylogenetic trees.” Bioinformatics, 30, 2216-2218
}
\author{
LJ Harmon, and JW Brown
This is a direct port of the geiger function, I import it here for convenience.
This code is copied under  GPL 3 license.
}
