% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeplyr_functions.R
\name{mutate_.treedata}
\alias{mutate_.treedata}
\alias{mutate.treedata}
\alias{mutate.grouped_treedata}
\alias{mutate_.grouped_treedata}
\alias{mutate_.grouped_treedata}
\title{Function for mutating an object of class \code{treedata}}
\usage{
\method{mutate_}{treedata}(.data, ..., .dots)

\method{mutate_}{grouped_treedata}(.data, ..., .dots)
}
\arguments{
\item{.data}{An object of class \code{treedata}}

\item{...}{Arguments to mutate the treedata object}

\item{.dots}{Used to work around non-standard evaluation. See \code{vignette}("nse") for details.}
}
\value{
An object of class \code{treedata} with new data added.
}
\description{
This function can be used to add new variables to a treedata object; see \code{\link{mutate}}.
}
\examples{
data(anolis)
td <- make.treedata(anolis$phy, anolis$dat)
tdmutate <- mutate(td, lnSVL = log(SVL), badassery = awesomeness + hostility)
}
\seealso{
\code{\link{mutate}}
}
