% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiener.R
\name{wiener}
\alias{wiener}
\title{Fast function using C++ to calculate the Wiener index}
\usage{
wiener(phy, normalization = FALSE, weight = TRUE)
}
\arguments{
\item{phy}{phylo object or ltable}

\item{normalization}{if TRUE, the Wiener index is normalized by the number of
nodes, e.g. by choose(n, 2), where n is the number of nodes.}

\item{weight}{if TRUE, branch lenghts are used.}
}
\value{
Wiener index
}
\description{
The Wiener index is defined as the sum of all shortest path
lengths between pairs of nodes in a tree.
}
\references{
Chindelevitch, Leonid, et al. "Network science inspires novel
tree shape statistics." Plos one 16.12 (2021): e0259877.
Mohar, B., Pisanski, T. How to compute the Wiener index of a graph.
J Math Chem 2, 267–277 (1988)
}
