% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_trelliscope.R
\name{facet_trelliscope}
\alias{facet_trelliscope}
\title{Facet Trelliscope}
\usage{
facet_trelliscope(
  facets,
  nrow = 1,
  ncol = 1,
  scales = "same",
  name = NULL,
  group = "common",
  desc = ggplot2::waiver(),
  md_desc = ggplot2::waiver(),
  path = NULL,
  height = 500,
  width = 500,
  state = NULL,
  jsonp = TRUE,
  as_plotly = FALSE,
  plotly_args = NULL,
  plotly_cfg = NULL,
  split_sig = NULL,
  self_contained = FALSE,
  thumb = TRUE,
  auto_cog = FALSE,
  split_layout = FALSE,
  data = ggplot2::waiver()
)
}
\arguments{
\item{facets}{formula to facet the panels on. Similar to \code{ggplot2::\link[ggplot2]{facet_wrap}}'s \code{facets}}

\item{nrow}{the number of rows of panels to display by default}

\item{ncol}{the number of columns of panels to display by default}

\item{scales}{should scales be the same (\code{"same"}, the default), free (\code{"free"}), or sliced (\code{"sliced"}). May provide a single string or two strings, one for the X and Y axis respectively.}

\item{name}{name of the display}

\item{group}{group that the display belongs to}

\item{desc}{description of the display}

\item{md_desc}{optional string of markdown that will be shown in the viewer for additional context about the display}

\item{path}{the base directory of the trelliscope application}

\item{height}{height in pixels of each panel}

\item{width}{width in pixels of each panel}

\item{state}{the initial state the display will open in}

\item{jsonp}{should json for display object be jsonp (TRUE) or json (FALSE)?}

\item{as_plotly}{should the panels be written as plotly objects?}

\item{plotly_args}{optional named list of arguments to send to \code{ggplotly}}

\item{plotly_cfg}{optional named list of arguments to send to plotly's \code{config} method}

\item{split_sig}{optional string that specifies the "signature" of the data splitting. If not specified, this is calculated as the md5 hash of the sorted unique facet variables. This is used to identify "related displays" - different displays that are based on the same faceting scheme. This parameter should only be specified manually if a display's faceting is mostly similar to another display's.}

\item{self_contained}{should the Trelliscope display be a self-contained html document? (see note)}

\item{thumb}{should a thumbnail be created?}

\item{auto_cog}{should auto cogs be computed (if possible)?}

\item{split_layout}{boolean that determines if the layout is split into components like a facet_grid vs. individual panels like facet_wrap.  Only applies to ggplot2 plot objects.}

\item{data}{data used for faceting. Defaults to the first layer data}
}
\description{
Facet Trelliscope
}
\note{
Note that \code{self_contained} is severely limiting and should only be used in cases where you would either like your display to show up in the RStudio viewer pane, in an interactive R Markdown Notebook, or in a self-contained R Markdown html document.
}
\examples{
\dontrun{
library(ggplot2)

# basically swap out facet_wrap for facet_trelliscope
qplot(cty, hwy, data = mpg) +
  facet_trelliscope(~ class + manufacturer)

# not required, but if you set labels, these will be added as
# descriptions to the cognostics that are automatically computed
mpg <- set_labels(mpg, mpg_labels)

qplot(cty, hwy, data = mpg) +
  theme_bw() +
  facet_trelliscope(~ manufacturer + class, nrow = 2, ncol = 4)

# using plotly
library(plotly)
qplot(cty, hwy, data = mpg) +
  theme_bw() +
  facet_trelliscope(~ manufacturer + class, nrow = 2, ncol = 4, as_plotly = TRUE)

qplot(class, cty, data = mpg, geom = c("boxplot", "jitter"), na.rm = TRUE) +
  facet_trelliscope(~ class, ncol = 7, height = 800, width = 200,
    state = list(sort = list(sort_spec("cty_mean")))) +
  theme_bw()

library(gapminder)
qplot(year, lifeExp, data = gapminder) +
  xlim(1948, 2011) + ylim(10, 95) + theme_bw() +
  facet_trelliscope(~ country + continent, nrow = 2, ncol = 7,
    width = 300, as_plotly = TRUE,
    plotly_cfg = list(displayModeBar = FALSE))
}
}
