% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_token.R
\name{get_token}
\alias{get_token}
\title{Get OAuth1.0 Token}
\usage{
get_token(
  app = NULL,
  key = NULL,
  secret = NULL,
  scope = c("read", "write", "account"),
  expiration = c("30days", "1day", "1hour", "never"),
  cache = getOption("httr_oauth_cache"),
  appname
)
}
\arguments{
\item{app}{A string, \code{NULL} or a Token.
\itemize{
\item If \code{key} and \code{secret} are set, a new token will be initialized and its
name set to this value. A meaningful name can help you to spot your token
on the settings page \verb{https://trello.com/username/account}. A token cannot
be initialized without a name, so it will default to \code{"trello-app"} if it
needs to.
\item If \code{key} and \code{secret} are not set, the value of \code{app} will be used
as a path from which an existing token is read. If \code{NULL}, the token will
be read from the working directory. \code{NULL} is returned if nothing is found.
\item If a Token, return as is.
}}

\item{key, secret}{Developer credentials from \verb{https://trello.com/app-key}
(see details). If \code{NULL} and a cache file exists, the newest token is read
from it, otherwise an error is thrown.}

\item{scope}{Can be one or several of \code{"read"}, \code{"write"} or \code{"account"}.
Defaults to \code{"read"}.}

\item{expiration}{Can be \code{"1hour"}, \code{"1day"}, \code{"30days"} or \code{"never"}.
Defaults to \code{"30days"}.}

\item{cache}{Passed to \code{\link[httr:oauth1.0_token]{httr::oauth1.0_token()}}. Can specify whether
the token should be cached locally (will ask the first time and then \code{TRUE}
by default) or choose an alternative path for the cache file.}

\item{appname}{Deprecated, use \code{app}.}
}
\value{
An object of class \code{"Trello_API_token"} (a Token).
}
\description{
Authorize access to Trello API, required for private boards and write access
(see details).
}
\section{Getting developer access}{


To access private data, a secure token is required. In order to create it,
you will need your developer \code{key} and \code{secret} which you can get by visiting
\verb{https://trello.com/app-key} after logging in to Trello. You may also
want to set at least one \emph{allowed origin} there. If you are using trelloR
locally (ie. from your laptop or PC), \verb{http://localhost:1410} is a good value
to use.
}

\section{Creating tokens}{


Once back in R, run this function the following way:

\code{my_token = get_token("my_app", key = key, secret = secret)}

passing the values you have obtained on the developer page. First time you
create a token, you will be prompted to confirm the authorization
in a browser. If you chose to store the token locally as prompted, you won't
have to do this anymore until your token expires (see \code{expiration}) or your
local cache file is deleted.

Tokens are stored inside a hidden \code{.httr-oauth} cache file and automatically
read when any function in the package is called. Optionally, you can specify
a different cache path using the \code{cache} argument, or avoid caching the token
completely with \code{cache = FALSE}. See \code{\link[httr:oauth1.0_token]{httr::oauth1.0_token()}} for details.

If you opt out of storing the token, then it will only be held until your
R session is over, and you will have to pass it to the \code{token} argument, eg.
\code{get_my_boards(token = my_token)} each time you are fetching data.

Remember to store your credentials in a \strong{secure, non-shared} location. To
minimize the risk of unwanted disclosure when using remote code
repositories, \code{.httr-oauth} (or whatever cache path you have specified
using the \code{cache} argument) is automatically added to \code{.gitignore}.
}

\examples{
# This example assumes you are reading your key and secret from environment
# variables. This is not obligatory, but wherever you read them from, make
# sure it is a secure, non-shared location.

\dontrun{

key = Sys.getenv("MY_TRELLO_KEY")
secret = Sys.getenv("MY_TRELLO_SECRET")

token = get_token("my_app", key = key, secret = secret,
                  scope = c("read", "write"))
}
}
\seealso{
\code{\link[httr:oauth_app]{httr::oauth_app()}}, \code{\link[httr:oauth_endpoint]{httr::oauth_endpoint()}},
\code{\link[httr:oauth1.0_token]{httr::oauth1.0_token()}}
}
