% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-evaluation.R
\name{evaluate_resampling}
\alias{evaluate_resampling}
\alias{evaluate_aic}
\alias{evaluate_models}
\title{Tools for model evaluation}
\usage{
evaluate_resampling(
  model,
  data,
  metrics = list(yardstick::rmse),
  v = nrow(data),
  repeats = 1
)

evaluate_aic(model, data)

evaluate_models(models, data, method = evaluate_resampling, ...)
}
\arguments{
\item{model}{A \link[trending:trending_model]{trending::trending_model} object.}

\item{data}{a \code{data.frame} containing data (including the response variable
and all predictors) used in \code{model}}

\item{metrics}{a list of functions assessing model fit, with a similar
interface to \code{\link[yardstick:rmse]{yardstick::rmse()}}; see
\url{https://yardstick.tidymodels.org/} for more information}

\item{v}{the number of equally sized data partitions to be used for K-fold
cross-validation; \code{v} cross-validations will be performed, each using \code{v - 1} partition as training set, and the remaining partition as testing set.
Defaults to 1, so that the method uses leave-one-out cross validation, akin
to Jackknife except that the testing set (and not the training set) is used
to compute the fit statistics.}

\item{repeats}{the number of times the random K-fold cross validation should
be repeated for; defaults to 1; larger values are likely to yield more
reliable / stable results, at the expense of computational time}

\item{models}{a \code{list} of models specified as an \code{\link[trending:trending_model]{trending::trending_model()}}
objects.}

\item{method}{a \code{function} used to evaluate models: either
\code{\link[=evaluate_resampling]{evaluate_resampling()}} (default, better for selecting models with good
predictive power) or \code{\link[=evaluate_aic]{evaluate_aic()}} (faster, focuses on goodness-of-fit
rather than predictive power)}

\item{...}{further arguments passed to the underlying method (e.g. \code{metrics},
\code{v}, \code{repeats}).}
}
\description{
These functions provide tools for evaluating \code{\link[trending:trending_model]{trending::trending_model}}s,
based on the goodness of fit or on predictive power. \code{\link[=evaluate_aic]{evaluate_aic()}}
evaluates the goodness of fit of a single model using Akaike's information
criterion, measuring the deviance of the model while penalising its
complexity. \code{\link[=evaluate_resampling]{evaluate_resampling()}} uses repeated K-fold cross-validation and
the Root Mean Square Error (RMSE) of testing sets to measure the predictive
power of a single model. \code{\link[=evaluate_aic]{evaluate_aic()}} is faster, but
\code{\link[=evaluate_resampling]{evaluate_resampling()}} is better-suited to select best predicting models.
\code{\link[=evaluate_models]{evaluate_models()}} uses either \code{\link[=evaluate_aic]{evaluate_aic()}} or \code{\link[=evaluate_resampling]{evaluate_resampling()}}
to compare a series of models.
}
\details{
These functions wrap around existing functions from several
packages. \code{\link[stats:AIC]{stats::AIC()}} is used in \code{\link[=evaluate_aic]{evaluate_aic()}}, and
\code{\link[=evaluate_resampling]{evaluate_resampling()}} uses \code{\link[rsample:vfold_cv]{rsample::vfold_cv()}} for cross-validation and
\code{\link[yardstick:rmse]{yardstick::rmse()}} to calculate RMSE.
}
\examples{
x <- rnorm(100, mean = 0)
y <- rpois(n = 100, lambda = exp(x + 1))
dat <- data.frame(x = x, y = y)

model <- trending::glm_model(y ~ x, poisson)
evaluate_resampling(model, dat)
evaluate_aic(model, dat)

models <- list(
  poisson_model = trending::glm_model(y ~ x, poisson),
  linear_model = trending::lm_model(y ~ x)
)
evaluate_models(models, dat)

}
\seealso{
\code{\link[stats:AIC]{stats::AIC()}} for computing AIC; \code{\link[rsample:vfold_cv]{rsample::vfold_cv()}} for cross
validation; \code{\link[yardstick:rmse]{yardstick::rmse()}} for calculating RMSE; \code{yardstick} also
implements a range of other metrics for assessing model fit outlined at
\url{https://yardstick.tidymodels.org/}; \code{\link[trending:trending_model]{trending::trending_model()}} for
the different ways to build the model objects.
}
