% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trinVUS.test.R
\name{trinVUS.test}
\alias{trinVUS.test}
\title{Trinormal VUS test}
\usage{
trinVUS.test(
  x1,
  y1,
  z1,
  x2 = 0,
  y2 = 0,
  z2 = 0,
  dat = NULL,
  paired = FALSE,
  conf.level = 0.95,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{x1, y1, z1}{non-empty numeric vectors of data from the healthy,
intermediate and diseased class from Classifier 1.}

\item{x2, y2, z2}{numeric vectors of data from the healthy, intermediate and
diseased class from Classifier 2, only needed in a comparison of two
classifiers.}

\item{dat}{a data frame of the following structure: The first column
represents a factor with three levels, containing the true class membership
of each measurement. The levels are ordered according to the convention of
higher values for more severe disease status. The second column contains
all measurements obtained from Classifier 1 (in the case of single marker
assessment). In the case of comparison of two markers, column three
contains the measurementss from the Classifier.}

\item{paired}{logical; indicating whether data arose from a paired setting.
If \code{TRUE}, each class must have equal sample size for both
classifiers.}

\item{conf.level}{confidence level of the interval. A numeric value between (0,1)
yielding the significance level \eqn{\alpha=1-\code{conf.level}}.}

\item{alternative}{character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}. You can specify
just the initial letter. For two sided test, notice \eqn{H0: Z = (VUS_1-VUS_2) /
(Var(VUS_1)+Var(VUS_2)-2Cov(VUS_1,VUS_2))^{0.5}}.}
}
\value{
A list of class \code{"htest"} containing the following components:
  \item{statistic}{the value of the Z-statistic.}
  \item{p.value}{the p-value for the test.}
  \item{conf.int}{a confidence interval for the test.}
  \item{estimate}{a data frame containing the
  estimated VUS from Classifier 1 and Classifier 2 (if specified).}
  \item{null.value}{a character expressing the null hypothesis.}
  \item{alternative}{a character string describing the alternative  hypothesis.}
  \item{method}{a character string indicating what type of trinormal VUS test was performed.}
  \item{data.name}{a character string giving the names of the data.} \item{Summary}{a data frame representing the
  number of NA's as well as the means and the standard deviations per class.}
  \item{Sigma}{the covariance matrix of the VUS.}
}
\description{
A statistical test function to assess three-class ROC data. It can be used
for assessment of a single classifier or comparison of two independent /
correlated classifiers, using the statistical test developed by Xiong et al.
(2007).
}
\details{
Based on the reference standard, this trinormal VUS test assesses the
  discriminatory power of classifiers by comparing the volumes under the ROC
  surfaces (VUS). It distinguishes between single classifier assessment,
  where a classifier is compared to the chance plane with VUS=1/6, and
  comparison between two classifiers. The latter case tests the equality
  between VUS_1 and VUS_2. The data can arise in a unpaired or paired
  setting. If \code{paired} is \code{TRUE}, a correlation is introduced which
  has to be taken into account. Therefore the sets of the two classifiers
  have to have classwise equal size. The data can be input as the data
  frame \code{dat} or as single vectors \code{x1, y1, z1, ...}.
}
\examples{
data(cancer)
data(krebs)

# investigate a single marker:
trinVUS.test(dat = cancer[,c(1,3)])
trinVUS.test(dat = krebs[,c(1,5)])

# result is equal to:
x1 <- with(cancer, cancer[trueClass=="healthy", 3])
y1 <- with(cancer, cancer[trueClass=="intermediate", 3])
z1 <- with(cancer, cancer[trueClass=="diseased", 3])
trinVUS.test(x1, y1, z1)

# comparison of marker 2 and 6:
trinVUS.test(dat = cancer[,c(1,3,5)], paired = TRUE)
trinVUS.test(dat = cancer[,c(1,3,5)], paired = FALSE)

# result is equal to:
x2 <- with(cancer, cancer[trueClass=="healthy", 5])
y2 <- with(cancer, cancer[trueClass=="intermediate", 5])
z2 <- with(cancer, cancer[trueClass=="diseased", 5])
trinVUS.test(x1, y1, z1, x2, y2, z2, paired = TRUE)
}
\references{
Xiong, C., Van Belle, G.  Miller J. P., Morris, J. C. (2006). Measuring and estimating
  diagnostic accuracy when there are three ordinal diagnostic groups.
  \emph{Statistics in Medicine}, \bold{25}(7), 1251–1273.

Xiong, C., van Belle, G.,  Miller, J. P.,  Yan, Y.,  Gao, F., Yu, K., and Morris, J. C. (2007). A parametric comparison
  of diagnostic accuracy with three ordinal diagnostic groups.
  \emph{Biometrical Journal}, \bold{49}(5), 682–693. \url{http://doi.org/10.1002/bimj.200610359}.
}
\seealso{
\code{\link{trinROC.test}}, \code{\link{boot.test}}.
}
