% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aberrantscores.R
\name{aberrantscores}
\alias{aberrantscores}
\title{Convert outcome to aberrant ranks}
\usage{
aberrantscores(ymat, cutoff, cutoff_dir = "less", tau = 0, treated1 = NULL)
}
\arguments{
\item{ymat}{A matrix of outcomes. Rows correspond to matched triples and
the three columns correspond to the three units in the match. The first unit
is the one treated unit if `treated1 == TRUE` or the one control unit if
`treated1 == FALSE`. The other two columns contain the remaining two units in
the match. These are control units if `treated1 == TRUE` or treated units if
`treated1 == FALSE`. This can easily be created from the triples match using
the [formattrip()] function with `type == "wide"`}

\item{cutoff}{The cutoff for whether an outcome is aberrant. Any outcome more extreme
then this cutoff will be considered aberrant}

\item{cutoff_dir}{Either `less` or `greater`, indicating whether outcomes should be
aberrant if they are less than the `cutoff` or greater than the `cutoff`, respectively}

\item{tau}{The null treatment effect to be subtracted from all treated units
before aberrant ranking commences. If `tau != 0`, then `treated1` is required}

\item{treated1}{A logical vector with length equal to the number of triples.
`TRUE` if there is only one treated unit in the matched triple; `FALSE` if
there are two treated units and only one control unit.
This can easily be created from the triples match using
the [formattrip()] function with `type == "wide"`}
}
\value{
A matrix similar to `ymat` in all regards other than the outcomes being
converted to aberrant ranks
}
\description{
Replaces non-aberrant responses by 0 and ranks the aberrant responses by severity.
The more aberrant responses have the highest ranks.
}
\details{
This can be useful for creating `scores` in [sentrip()] for an aberrant rank test.
}
\examples{
# Generate some data
set.seed(246)
n <- 30
x <- rnorm(n, 0, 3)
nt <- floor(n * 0.5)
nc <- n - nt
z <- c(rep(1, nt), rep(0, nc))
# Create a distance matrix, everything in one stratum
dist <- dist_mahal(data.frame(x = x), z, rep(1, n))[[1]]
# Create the triples match
triplesm <- triples_st(cost = dist, z = z, solver = "rlemon")
# Create an outcome
y <- 1:40
# Give the outcome some random unit names
names(y) <- sample(1:40)
# Reformat the triples match
ywide <- formattrip(m = triplesm, y = y, type = "wide")
# Turn the outcome into scores, in this case aberrant ranks
ab <- aberrantscores(ywide$ymat, 15, cutoff_dir = "less", tau = 0, treated1 = NULL)
# Conduct a one-sided hypothesis test with a bias of gamma = 1.25
sentrip(scores = ab, treated1 = ywide$treated1, gamma = 1.25, alternative = "greater")

}
\seealso{
aberrantscoreslong for the same function with inputs given in the long format as opposed to the wide format

formattrip for formatting the triples match into long or wide format
}
