% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{get_model_data}
\alias{get_model_data}
\title{Get Ratings Data with Model Predictors}
\usage{
get_model_data()
}
\value{
A data frame, with columns:

\describe{
  \item{subj_id}{Unique subject identifier.}
  \item{stim_id}{Unique stimulus identifier.}
  \item{repetition}{Whether the statement was repeated or new.}
  \item{interval}{Presentation interval.}
  \item{R}{Deviation-coded numerical predictor for repetition.}
  \item{I1}{Deviation-coded numerical predictor for interval (1 day vs. immediate).}
  \item{I2}{Deviation-coded numerical predictor for interval (1 week vs. immediate).}
  \item{I3}{Deviation-coded numerical predictor for interval (1 month vs. immediate).}
  \item{Rep}{Deviation-coded factor for repetition.}
  \item{Int}{Deviation-coded factor for interval.}
}
}
\description{
Apply participant/phase-level exclusions and then add numeric and
factor predictors to the ratings data.
}
\examples{
get_model_data()

}
\seealso{
\code{\link{truth_trajectory_data}}
}
